%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%    Visualizing the electric dipole field


clear all;
close all;
eo = 8.854e-12; % Permittivity of air (F/m)
p = 10^(-12); % Moment of electric dipole (C m)
[x,z]=meshgrid(0.1:0.001:0.4, -0.15:0.001:0.15);
% Radial distance
r = sqrt(x.^2 + z.^2);
% Electric field
E = p./(4*pi*eo*r.^3).*sqrt(((2*z./r).^2 + (x./r)).^2);
figure(1);
pcolor(x,z,E);
xlabel('x (m)');
ylabel('z (m)');
title('Intensity of electric field vector in plane y=0');
shading interp;
colorbar;

